Session closeout. Wrap everything up.

**Process:**

### 1. Session Summary

Summarize what was accomplished this session in 3-5 bullet points.

### 2. Regression Gate

Before anything else, verify the codebase is healthy:

- Run `npm run dashboard:check` (typecheck + lint)
- Run `npm run dashboard:test` (all tests green)
- If either fails: **STOP.** Fix the issue before proceeding. Do not wrap a broken session.

### 3. Commit Discipline Audit

Review all commits made this session (`git log` since session start):

- Verify no commits mix `refactor:` and `feat:` changes
- Verify every `feat:` commit touching pricing/orders/data flow includes tests
- If violations found: flag them to StreamRift, recommend follow-up

### 4. Update Tracking Documents

Update each document that changed this session. Skip any that aren't relevant.

**`docs/bugs.md`** — If bugs were found or fixed:

- Move fixed bugs to the Closed table with fix commit hash
- Add new bugs with severity (`critical`/`high`/`medium`/`low`)

**`docs/backlog.md`** — If features were shipped or new requests surfaced:

- Mark shipped features with version and status
- Add new requests with source, priority, and notes

**`docs/changelog.md`** — If anything user-facing changed (features, fixes, UI changes):

- Add entries under the current version heading
- Use Keep a Changelog format: `Added`, `Changed`, `Fixed`, `Removed`
- This feeds the future in-app changelog — write for traders, not engineers

**`docs/versions/vX.Y.Z.md`** — If working on a version plan:

- Check off completed items
- Note any items that shifted scope or got deferred

### 5. Version & Phase Progress

Report progress against the active milestone:

- **Current version:** What items are done vs remaining?
- **Phase 1 exit criteria** (if stabilization is active):
  - [ ] Dead code removed — every component reachable from production route
  - [ ] Zero duplicate type definitions for core domain types
  - [ ] 25+ tests covering pricing, orders, normalization, data pipeline
  - [ ] `dashboard:check` and `dashboard:test` both pass clean
  - [ ] `docs/refactor-base-1.md` documents the new baseline
- State what percentage of the current milestone is complete

### 6. Write Session Debrief

Write to `.hand/reports/{today's date}-{short-description}.md`:

- What was built/changed
- Key decisions made and why
- What's working
- What's unfinished or needs attention
- Phase/version progress snapshot

### 7. Update Auto-Memory

Update MEMORY.md with current project state for next session continuity. Keep it concise — this is loaded on every boot.

### 8. Recommend Next Session

- What should we start with next time?
- Are there any blockers that need to be resolved before then?
- Any time-sensitive items (feedback dumps, deploy windows, calendar gates)?

### 9. Commit & Push

Stage all session artifacts (reports, docs, memory, code changes) and commit:

- Use prefix `docs:` for documentation-only sessions
- Use prefix `chore:` for mixed sessions
- Use the session summary as the commit message body
- Always include `Co-Authored-By: Claude Opus 4.6 <noreply@anthropic.com>`

Push to remote (`git push`) to save the session.

### 10. Sign Off

Say goodbye.
