# Notes for Brendan

Handoff notes from StreamRift. Read these before merging `streamrift-0` to `main`.

## What's in this push

### 1. Response Cache for HTTP Relay (new feature)

- **Files:** `apps/relay/src/responseCache.ts` (new), `config.ts` (modified), `index.ts` (modified)
- **What it does:** Caches GET responses for public Kalshi endpoints at the relay level. When multiple users load the dashboard, the first one's discovery calls get cached and subsequent users get the cached response instead of burning API calls.
- **TTLs:** Markets discovery (5 min), event metadata (30 min), orderbook snapshots (30 sec)
- **Config:** `RELAY_CACHE_ENABLED=false` to disable (defaults to on)
- **Production tested:** Deployed and validated on g1.newbx.com — 160 cache hits within 7 minutes of first load
- **Detailed analysis:** See `relay-response-cache-analysis.md` in this folder

### 2. CLAUDE.md — Workflow section

- Added the Hand/StreamRift workflow section pointing to `.streamrift/` directives
- No functional changes to the codebase

### 3. ADR Template

- `docs/decisions/TEMPLATE.md` — Architecture Decision Record template for documenting important decisions going forward

## What's NOT in this push

- No dashboard changes — all existing dashboard code is unchanged
- Smart relay is unaffected — the response cache is a separate, simpler layer
- No changes to the CI/CD pipeline

## Deployment notes (g1.newbx.com)

- g1.newbx.com is a separate test box (OVH EU, cPanel, user `g1bx`)
- No nginx proxy — relay terminates SSL directly on port 8787
- No PM2 — relay runs via `nohup` with `start.sh`/`stop.sh`
- Dashboard served from `~/public_html/` at root `/` (not `/dashboard` subpath)
- This is independent of the kt.gbuff.com / dv.gbuff.com CI pipeline

## Things to review

1. The event listing cache pattern may need a second regex — see "Open Questions" in the analysis doc
2. Market discovery TTL (5 min) could be bumped to 15-30 min if we want more savings
3. No cache invalidation endpoint yet — restart is the only way to bust it

## File index

- `relay-response-cache-analysis.md` — Full technical deep-dive on the caching layer
- `README.md` — This file
