# Welcome to StreamRift Land

Hey Domino. You're looking at Galactus — the trading terminal. This is your starting codebase.

---

## Get Running in 2 Minutes

### 1. Run the setup script

```bash
chmod +x setup.sh && ./setup.sh
```

This does everything: installs SSH keys, configures git remote, fetches the `domino-0` branch, and runs `npm install`. You'll be connected to the repo when it finishes.

### 2. Start the dev server

```bash
npm run dashboard:dev
```

Open `http://localhost:5173` — password: `streamrift`

### 3. Start your AI assistant

```bash
claude
```

Type `/get-started` for the first-time setup interview. It'll learn how you work and rotate your SSH keys to your own personal ones.

---

## What the Setup Script Did

- Installed an SSH key to `~/.ssh/g1_domino`
- Added an SSH config entry (`Host g1` → `g1.newbx.com`)
- Set up the git remote (`origin` → `g1:git/g1.1.git`)
- Checked out the `domino-0` branch
- Installed npm dependencies

The SSH key included in this zip is a **bootstrap key** — it works immediately but gets replaced with your own personal key when you run `/get-started`.

---

## Validate the Build

```bash
npm run dashboard:check    # typecheck + lint
npm run dashboard:test     # 53 tests, all should pass
```

---

## Your Workflow

1. **Work locally** — edit code, run `npm run dashboard:dev` to see changes
2. **Validate** — run `npm run dashboard:check` before pushing
3. **Push** — `git push origin domino-0` auto-deploys to `domino.dev.g1.newbx.com`
4. **Check deploy** — visit `https://domino.dev.g1.newbx.com`

### AI Assistant Commands

Your AI assistant reads `DOMINO.md` and `CLAUDE.md` for project context:

- `/get-started` — first-time setup (run this first!)
- `/domino-run-it` — start a coding session
- `/domino-wrap-it` — end a session (your "save button")

---

## Key Files to Know

| File | What it is |
|------|-----------|
| `DOMINO.md` | Your operating guide — read this first |
| `CLAUDE.md` | Project conventions (build commands, rules, architecture) |
| `apps/dashboard/src/App.tsx` | Where everything starts |
| `apps/dashboard/src/lib/kalshiApi.ts` | Kalshi exchange API |
| `apps/dashboard/src/lib/polymarket/` | Polymarket integration |
| `apps/dashboard/src/components/atoms/` | Reusable UI components |
| `docs/backlog.md` | Feature ideas to build |

---

## When You're Stuck

1. Push what you have: `git commit -m "wip: description" && git push origin domino-0`
2. Leave a note: `// TODO(domino): what's wrong`
3. Message StreamRift — he'll take it from there

---

**Your sandbox is yours to crash and rebuild. Experiment freely. Let's get to it.**
