/**
 * MoneyText - Display dollar amounts
 */

import { cn } from '@/lib/utils';
import { TEXT_SIZE_CLASSES, type SizeVariant } from '@/lib/sizeClasses';

interface MoneyTextProps {
  value: number;
  size?: SizeVariant;
  showSign?: boolean;
  colorCode?: boolean;
  className?: string;
}

export function MoneyText({
  value,
  size = 'md',
  showSign = false,
  colorCode = false,
  className,
}: MoneyTextProps) {
  const isPositive = value > 0;
  const isNegative = value < 0;
  const absValue = Math.abs(value);

  const formatted = new Intl.NumberFormat('en-US', {
    style: 'currency',
    currency: 'USD',
    minimumFractionDigits: 2,
    maximumFractionDigits: 2,
  }).format(absValue);

  const sign = showSign && isPositive ? '+' : '';
  const display = isNegative ? `-${formatted}` : `${sign}${formatted}`;

  const colorClass = colorCode
    ? isPositive
      ? 'text-green-500'
      : isNegative
        ? 'text-red-500'
        : 'text-foreground'
    : '';

  return (
    <span className={cn('font-mono tabular-nums', TEXT_SIZE_CLASSES[size], colorClass, className)}>
      {display}
    </span>
  );
}

export default MoneyText;
