/**
 * SideBadge - YES/NO side indicator
 */

import { cn } from '@/lib/utils';

interface SideBadgeProps {
  side: 'yes' | 'no';
  size?: 'xs' | 'sm' | 'md';
  className?: string;
}

const sizeClasses = {
  xs: 'text-[10px] px-1.5 py-0.5 min-w-[28px]',
  sm: 'text-xs px-2 py-0.5 min-w-[32px]',
  md: 'text-sm px-2.5 py-1 min-w-[40px]',
};

export function SideBadge({ side, size = 'sm', className }: SideBadgeProps) {
  const isYes = side === 'yes';

  return (
    <span
      className={cn(
        'inline-flex items-center justify-center rounded font-semibold uppercase tracking-wide',
        sizeClasses[size],
        isYes
          ? 'border border-emerald-500/30 bg-emerald-500/20 text-emerald-400'
          : 'border border-rose-500/30 bg-rose-500/20 text-rose-400',
        className
      )}
    >
      {isYes ? 'YES' : 'NO'}
    </span>
  );
}

export default SideBadge;
