/**
 * ExploreView - Market discovery and exploration
 *
 * Uses the MarketExplorer component to browse all available markets.
 * Navigation is URL-driven for proper back button support and deep linking.
 */

import { MarketExplorer } from '@/components/market-explorer/MarketExplorer';
import type { KalshiApiClient } from '@/lib/kalshiApi';
import type { KalshiCredentials } from '@/types';

// URL params for the explore hierarchy
interface ExploreParams {
  category?: string;
  series?: string;
  event?: string;
}

interface ExploreViewProps {
  apiClient: KalshiApiClient;
  credentials?: KalshiCredentials;
  params?: ExploreParams;
}

export function ExploreView({ apiClient, params }: ExploreViewProps) {
  // MarketExplorer handles all navigation via URL
  return (
    <div className="h-full">
      <MarketExplorer
        apiClient={apiClient}
        params={params}
        className="h-full"
      />
    </div>
  );
}
