/**
 * LoginView - Non-authenticated login screen
 *
 * Centered credentials panel for logging in.
 */

import CredentialsPanel from '@/components/CredentialsPanel';

interface LoginViewProps {
  onConnect: (
    accessKey: string,
    privateKey: string,
    environment: 'prod' | 'demo',
    useRelay: boolean,
    remember: boolean
  ) => Promise<void>;
  error?: string | null;
}

export function LoginView({ onConnect, error }: LoginViewProps) {
  return (
    <div className="bg-background flex min-h-screen flex-col items-center justify-center p-4">
      <div className="w-full max-w-md">
        {/* Logo/Title */}
        <div className="mb-8 text-center">
          <h1 className="text-foreground text-2xl font-bold">Kalshi Terminal</h1>
          <p className="text-muted-foreground mt-2 text-sm">Connect to start trading</p>
        </div>

        {/* Credentials Panel */}
        <div className="bg-card border-border rounded-lg border p-6">
          <CredentialsPanel
            onConnect={onConnect}
            onDisconnect={() => {}}
            isConnected={false}
          />
        </div>

        {/* Error Display */}
        {error && (
          <div className="bg-destructive/10 border-destructive/20 mt-4 rounded-lg border p-3">
            <p className="text-destructive text-sm">{error}</p>
          </div>
        )}
      </div>
    </div>
  );
}
