/**
 * Diagnostics Types
 *
 * Type definitions for the in-app diagnostics system.
 */

import type { ConsolidatedGameBooks } from '../nbaConsolidated/types';
import type { GameData } from '../sportsStream';
import type { KalshiApiClient } from '../../types';

export type DiagnosticStatus = 'pending' | 'running' | 'pass' | 'fail' | 'warn' | 'skip';

export type DiagnosticCategory = 'connectivity' | 'discovery' | 'stream' | 'data' | 'date';

export interface DiagnosticCheck {
  id: string;
  category: DiagnosticCategory;
  name: string;
  description: string;
}

export interface DiagnosticResult {
  checkId: string;
  status: DiagnosticStatus;
  message: string;
  durationMs: number;
  timestamp: number;
  details?: Record<string, unknown>;
}

export interface DiagnosticContext {
  /** Kalshi API client (null if not connected) */
  apiClient: KalshiApiClient | null;
  /** Kalshi credentials */
  credentials: { accessKeyId: string } | null;
  /** Consolidated NBA games */
  consolidatedGames: ConsolidatedGameBooks[];
  /** Multi-sport games (keyed by "{sport}-{marketType}") */
  sportsGames: Map<string, GameData[]>;
  /** Feed status */
  feedStatus: 'live' | 'offline';
  /** Last update time string */
  lastUpdateTime: string;
}
