import { describe, expect, it } from 'vitest';
import { polyAsksAsNoLevels, polyBidsAsYesLevels } from './normalize';

describe('polymarket normalize', () => {
  it('converts bids to YES bid levels (cents)', () => {
    const yes = polyBidsAsYesLevels([
      { price: 0.57, size: 10 },
      { price: 0.56, size: 5 },
    ]);
    expect(yes.map((x) => x.priceCents)).toEqual([57, 56]);
  });

  it('inverts asks into NO bid levels (cents)', () => {
    const no = polyAsksAsNoLevels([
      { price: 0.61, size: 5 }, // YES ask 61c => NO bid 39c
      { price: 0.7, size: 1 }, // => 30c
    ]);
    expect(no.map((x) => x.priceCents)).toEqual([39, 30]);
  });
});
