import type { BookLevel } from '@/lib/nbaConsolidated/types';
import type { PolyBookLevel } from './marketStream';

export function polyBidsAsYesLevels(bids: PolyBookLevel[]): BookLevel[] {
  return bids
    .map((lvl) => ({ priceCents: Math.round(Number(lvl.price) * 100), size: Number(lvl.size) }))
    .filter(
      (x) =>
        Number.isFinite(x.priceCents) &&
        x.priceCents > 0 &&
        x.priceCents < 100 &&
        Number.isFinite(x.size) &&
        x.size > 0
    )
    .sort((a, b) => b.priceCents - a.priceCents);
}

/**
 * Polymarket CLOB book is for the token (YES outcome). To match the `nba/` UI convention
 * where both `yes` and `no` are **bid ladders**, we invert the YES asks into NO bids:
 * \(NO_bid_cents = 100 - YES_ask_cents\).
 */
export function polyAsksAsNoLevels(asks: PolyBookLevel[]): BookLevel[] {
  return asks
    .map((lvl) => ({
      priceCents: 100 - Math.round(Number(lvl.price) * 100),
      size: Number(lvl.size),
    }))
    .filter(
      (x) =>
        Number.isFinite(x.priceCents) &&
        x.priceCents > 0 &&
        x.priceCents < 100 &&
        Number.isFinite(x.size) &&
        x.size > 0
    )
    .sort((a, b) => b.priceCents - a.priceCents);
}
