/**
 * Kalshi price helpers
 *
 * Many Kalshi endpoints represent prices as either:
 * - probability in dollars (0.00 - 1.00), or
 * - integer cents (0 - 100).
 *
 * Internally in this app we treat prices as probability (0.00 - 1.00).
 */

export function normalizeKalshiPriceToProbability(raw: number | null | undefined): number | null {
  if (raw === null || raw === undefined) return null;
  if (!Number.isFinite(raw)) return null;

  // Heuristic: if it looks like cents, convert to probability.
  // (Valid probability is <= 1.0; valid cents are typically 0..100.)
  if (raw > 1.01) return raw / 100;
  return raw;
}
