/**
 * Sports Discovery Module
 *
 * Unified market discovery for all supported Kalshi sports:
 * - NBA, NFL, NHL, CBB (Men's), Tennis (ATP/WTA)
 * - Market types: moneyline, spread, total
 */

// Types
export {
  type Sport,
  type MarketType,
  type SportConfig,
  type SeriesConfig,
  type ParsedEventInfo,
  type ParsedMarketInfo,
  SPORT_CONFIGS,
  SERIES_CONFIGS,
  getSeriesTicker,
  getSportConfig,
  getAllSeriesForSport,
  getConfigFromSeriesTicker,
} from './types';

// Ticker parsing
export { parseEventTicker, parseMarketTicker, buildEventTicker } from './tickerParser';

// Discovery
export {
  type DiscoveryOptions,
  type DiscoveredMarket,
  type GroupedEvent,
  discoverSportsMarkets,
  groupMarketsByEvent,
  discoverAllMarketsForSport,
} from './discover';
