import { describe, expect, it } from 'vitest';
import { orderbookToLevels } from './stream';

describe('orderbookToLevels', () => {
  it('converts normal tuples sorted descending by price', () => {
    const raw: [number, number][] = [
      [30, 100],
      [50, 200],
      [40, 150],
    ];
    const result = orderbookToLevels(raw);
    expect(result).toEqual([
      { priceCents: 50, size: 200 },
      { priceCents: 40, size: 150 },
      { priceCents: 30, size: 100 },
    ]);
  });

  it('returns empty array for null input', () => {
    expect(orderbookToLevels(null)).toEqual([]);
  });

  it('returns empty array for undefined input', () => {
    expect(orderbookToLevels(undefined)).toEqual([]);
  });

  it('skips malformed entries', () => {
    const raw: [number, number][] = [
      [50, 100],
      [NaN, 200],
      [30, -5], // size <= 0 skipped
      [40, 50],
    ];
    const result = orderbookToLevels(raw);
    expect(result).toEqual([
      { priceCents: 50, size: 100 },
      { priceCents: 40, size: 50 },
    ]);
  });

  it('handles empty array', () => {
    expect(orderbookToLevels([])).toEqual([]);
  });
});
