import 'katex/dist/katex.min.css';
import { InlineMath, BlockMath } from 'react-katex';

interface FormulaProps {
  children: string;
  block?: boolean;
}

/**
 * Renders mathematical formulas using KaTeX.
 *
 * @example
 * // Inline formula
 * <Formula>EV = P_{win} \times Profit</Formula>
 *
 * // Block formula (centered, larger)
 * <Formula block>f^* = \frac{bp - q}{b}</Formula>
 *
 * Common LaTeX:
 * - Subscript: x_{sub}
 * - Superscript: x^{sup}
 * - Fraction: \frac{a}{b}
 * - Multiply: \times
 * - Plus/minus: \pm
 * - Greater/less or equal: \geq \leq
 * - Sum: \sum_{i=0}^{n}
 * - Square root: \sqrt{x}
 */
export function Formula({ children, block = false }: FormulaProps) {
  if (block) {
    return <BlockMath math={children} />;
  }
  return <InlineMath math={children} />;
}
