/**
 * Guides App Entry Point
 *
 * Standalone app for trading guides with KaTeX support.
 */

import React from 'react';
import ReactDOM from 'react-dom/client';
import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom';
import { GuidesLayout, GuidesIndexPage, GuidePage } from './pages';

import './globals.css';

// Router basename for subdirectory deployment (e.g., "/guides")
const routerBasename = import.meta.env.VITE_ROUTER_BASE || '';

ReactDOM.createRoot(document.getElementById('root')!).render(
  <React.StrictMode>
    <BrowserRouter basename={routerBasename}>
      <Routes>
        {/* Index page */}
        <Route
          path="/"
          element={
            <GuidesLayout>
              <GuidesIndexPage />
            </GuidesLayout>
          }
        />

        {/* Individual guide page */}
        <Route
          path="/:slug"
          element={
            <GuidesLayout>
              <GuidePage />
            </GuidesLayout>
          }
        />

        {/* Catch-all redirect */}
        <Route
          path="*"
          element={
            <Navigate
              to="/"
              replace
            />
          }
        />
      </Routes>
    </BrowserRouter>
  </React.StrictMode>
);
