/**
 * Configuration Management
 *
 * Loads and validates server configuration from environment variables.
 */
/**
 * Server configuration interface.
 */
export interface ServerConfig {
    /** HTTP/WebSocket server port */
    port: number;
    /** Node environment */
    nodeEnv: 'development' | 'production';
    /** CORS origin (string for specific origin, true for all origins) */
    corsOrigin: string | boolean;
    /** HTTP request timeout in milliseconds */
    httpTimeoutMs: number;
    /** WebSocket reconnect delay in milliseconds */
    wsReconnectDelayMs: number;
    /** Maximum WebSocket reconnection attempts */
    wsMaxReconnectAttempts: number;
    /** Maximum request body size in bytes */
    requestSizeLimit: number;
    /** Kalshi base URL (for validation only) */
    kalshiBaseUrl: string;
    /** Enable smart relay mode (caches market data, streams to clients) */
    smartRelayEnabled: boolean;
    /** How often to re-discover markets in ms (default 300000 = 5 min) */
    smartRelayRefreshMs: number;
    /** Kalshi WebSocket URL */
    kalshiWsUrl: string;
    /** Polymarket WebSocket URL */
    polymarketWsUrl: string;
    /** Bearer token for /admin/* endpoints. If unset, admin endpoints return 503. */
    adminSecret: string | undefined;
    /** Token for /stream/markets WS auth. If unset, stream is open (dev only). */
    streamToken: string | undefined;
    /** Cache TTL in ms (entries older than this are pruned). Default 24h. */
    cacheTtlMs: number;
    /** Enable response cache for GET relay requests (default true) */
    relayCacheEnabled: boolean;
}
/**
 * Loads and validates server configuration from environment variables.
 *
 * @returns ServerConfig with validated values
 * @throws Error if required config is missing or invalid
 */
export declare function loadConfig(): ServerConfig;
//# sourceMappingURL=config.d.ts.map