/**
 * HTTP Relay
 *
 * Forwards HTTP requests from client to Kalshi API with byte-faithful precision.
 */
import { HttpRelayRequest, HttpRelayResponse } from '@galactus/shared';
import { ServerConfig } from './config.js';
import { Logger } from './logger.js';
/**
 * Validates an HTTP relay request.
 *
 * @param request - Request to validate
 * @throws ValidationError if request is invalid
 */
export declare function validateHttpRequest(request: HttpRelayRequest): void;
/**
 * Forwards an HTTP request from client to Kalshi API.
 *
 * Forwards the request byte-faithfully:
 * - All headers forwarded exactly as received
 * - Body forwarded exactly as received (no parsing/re-stringifying)
 * - Query parameters preserved exactly
 *
 * @param request - HttpRelayRequest from client
 * @param config - Server configuration
 * @param logger - Logger instance
 * @returns HttpRelayResponse with Kalshi API response
 * @throws RelayError on forwarding failures
 */
export declare function forwardHttpRequest(request: HttpRelayRequest, config: ServerConfig, logger: Logger): Promise<HttpRelayResponse>;
//# sourceMappingURL=httpRelay.d.ts.map