/**
 * Relay Server Main Entry Point
 *
 * Sets up Express HTTP server and WebSocket server.
 */
import 'dotenv/config';
/**
 * Main server instance.
 */
declare class RelayServer {
    private app;
    private httpServer;
    private wsServer;
    private wsRelay;
    private config;
    private logger;
    private smartRelay;
    private streamWsServer;
    private responseCache;
    constructor();
    /**
     * Sets up Express middleware.
     */
    private setupMiddleware;
    /**
     * Sets up Express routes.
     */
    private setupRoutes;
    /**
     * Sets up graceful shutdown handlers.
     */
    private setupGracefulShutdown;
    /**
     * Starts the server.
     */
    start(): Promise<void>;
}
export { RelayServer };
//# sourceMappingURL=index.d.ts.map