/**
 * Structured Logging
 *
 * Provides structured logging with sanitization of sensitive data.
 */
import { ServerConfig } from './config.js';
/**
 * Logger interface.
 */
export interface Logger {
    error(message: string, meta?: Record<string, unknown>): void;
    warn(message: string, meta?: Record<string, unknown>): void;
    info(message: string, meta?: Record<string, unknown>): void;
    debug(message: string, meta?: Record<string, unknown>): void;
}
/**
 * Creates a logger instance.
 *
 * Uses console for now. Can be replaced with pino, winston, etc.
 *
 * @param config - Server configuration
 * @returns Logger instance
 */
export declare function createLogger(config: ServerConfig): Logger;
//# sourceMappingURL=logger.d.ts.map