/**
 * CORS Middleware
 *
 * Configures CORS for Express server.
 */
import { RequestHandler } from 'express';
import { ServerConfig } from '../config.js';
/**
 * Creates CORS middleware for Express.
 *
 * - Development: allows all origins
 * - Production: restricts to configured origin(s)
 *
 * @param config - Server configuration
 * @returns Express CORS middleware
 */
export declare function createCorsMiddleware(config: ServerConfig): RequestHandler;
//# sourceMappingURL=cors.d.ts.map