/**
 * Error Handling Middleware
 *
 * Global error handler for Express.
 */
import { ErrorRequestHandler } from 'express';
import { Logger } from '../logger.js';
/**
 * Express error handling middleware.
 *
 * Catches all errors and returns standardized error responses.
 * Never exposes stack traces in production.
 *
 * @param logger - Logger instance
 * @returns Express error handler middleware
 */
export declare function createErrorHandler(logger: Logger): ErrorRequestHandler;
//# sourceMappingURL=errorHandler.d.ts.map