/**
 * Response Cache for HTTP Relay
 *
 * Caches GET responses for known Kalshi endpoints that return identical data
 * for all users (market discovery, event metadata, orderbook snapshots).
 * Keyed by URL only — auth headers differ per user but responses are the same.
 */
import { HttpRelayResponse } from '@galactus/shared';
interface CacheStats {
    hits: number;
    misses: number;
    entries: number;
}
export declare class ResponseCache {
    private cache;
    private hits;
    private misses;
    private pruneTimer;
    constructor();
    /**
     * Build a cache key from a URL. Returns null if the URL is not cacheable.
     */
    buildKey(url: string): string | null;
    /**
     * Get a cached response if it exists and is still fresh.
     */
    get(key: string): Omit<HttpRelayResponse, 'id'> | null;
    /**
     * Store a response if the URL matches a cacheable pattern.
     */
    tryStore(url: string, response: HttpRelayResponse): void;
    getStats(): CacheStats;
    destroy(): void;
    private getTtl;
    private prune;
}
export {};
//# sourceMappingURL=responseCache.d.ts.map