/**
 * KalshiFetcher — Persistent Kalshi REST + WebSocket data fetcher.
 *
 * On startup:
 *  1. REST: discover NBA markets via /trade-api/v2/events (public, no auth)
 *  2. REST: fetch initial orderbooks for all discovered tickers
 *  3. WS: connect to Kalshi WebSocket and subscribe to orderbook_delta + ticker + trade channels
 *
 * Features:
 *  - API key rotation via ApiKeyStore (round-robin across healthy keys)
 *  - 429 rate-limit handling with Retry-After parsing and adaptive backoff
 *  - Auto-disables keys on 401 Unauthorized
 *  - Writes all updates into the shared MarketCache
 *  - Periodic re-discovery every smartRelayRefreshMs to pick up new games
 *  - WebSocket reconnection with exponential backoff
 */
import type { ServerConfig } from '../config.js';
import type { Logger } from '../logger.js';
import type { MarketCache } from './MarketCache.js';
import type { ApiKeyStore } from './ApiKeyStore.js';
export declare class KalshiFetcher {
    private config;
    private logger;
    private cache;
    private keyStore;
    private ws;
    private discoveredTickers;
    private refreshTimer;
    private reconnectTimer;
    private reconnectAttempts;
    private maxReconnectAttempts;
    private stopped;
    private _isConnected;
    private nextMsgId;
    constructor(config: ServerConfig, logger: Logger, cache: MarketCache, keyStore: ApiKeyStore);
    get isConnected(): boolean;
    start(): Promise<void>;
    stop(): void;
    /**
     * Make an HTTP GET to Kalshi with optional API key auth.
     * Uses key rotation if keys are available, falls back to unauthenticated.
     * Handles 429 with retry-after and 401 with key disabling.
     */
    private kalshiGet;
    private discover;
    private fetchOrderbook;
    private connectWs;
    private subscribeAll;
    private handleWsMessage;
    private handleOrderbookMessage;
    private handleTickerMessage;
    private handleTradeMessage;
    private deriveMarketPriceFromOrderbook;
    private scheduleReconnect;
}
//# sourceMappingURL=KalshiFetcher.d.ts.map