/**
 * PM2 ecosystem config for galactus-relay.
 * Pins cwd to this directory so node_modules resolve correctly.
 * Loads .env via node_args so env is independent of process cwd.
 * Do not remove cwd, node_args, or env.DOTENV_CONFIG_PATH; relay fails under PM2 without them. See docs/devops.md.
 */
const path = require('path');

module.exports = {
  apps: [
    {
      name: 'galactus-relay',
      script: 'dist/index.js',
      cwd: __dirname,
      node_args: '-r dotenv/config',
      env: {
        DOTENV_CONFIG_PATH: path.join(__dirname, '.env'),
      },
    },
  ],
};
