/**
 * CORS Middleware
 *
 * Configures CORS for Express server.
 */

import { RequestHandler } from 'express';
import cors from 'cors';
import { ServerConfig } from '../config.js';

/**
 * Creates CORS middleware for Express.
 *
 * - Development: allows all origins
 * - Production: restricts to configured origin(s)
 *
 * @param config - Server configuration
 * @returns Express CORS middleware
 */
export function createCorsMiddleware(config: ServerConfig): RequestHandler {
  const corsOptions: cors.CorsOptions = {
    origin: config.corsOrigin,
    credentials: true,
    methods: ['GET', 'POST', 'PUT', 'DELETE', 'PATCH', 'OPTIONS'],
    allowedHeaders: ['Content-Type', 'Authorization'],
  };

  return cors(corsOptions);
}
