/**
 * Jest setup file for relay server tests
 *
 * This file runs before each test suite.
 * Use it to set up global test configuration, mocks, or test utilities.
 */

// Set test environment variables if not already set
process.env.NODE_ENV = process.env.NODE_ENV || 'test';
process.env.PORT = process.env.PORT || '8787';
process.env.KALSHI_BASE_URL = process.env.KALSHI_BASE_URL || 'https://api.elections.kalshi.com';
process.env.HTTP_TIMEOUT_MS = process.env.HTTP_TIMEOUT_MS || '30000';
process.env.WS_RECONNECT_DELAY_MS = process.env.WS_RECONNECT_DELAY_MS || '1000';
process.env.WS_MAX_RECONNECT_ATTEMPTS = process.env.WS_MAX_RECONNECT_ATTEMPTS || '5';
process.env.REQUEST_SIZE_LIMIT = process.env.REQUEST_SIZE_LIMIT || '10485760';
process.env.CORS_ORIGIN = process.env.CORS_ORIGIN || '*';

// Increase timeout for integration tests
jest.setTimeout(30000);
