# Running Bug List

> Living document. Updated each session. Sorted by priority.
> **Version: `streamrift-0.3`** — 2026-02-17

---

## Closed Bugs

| Bug         | Summary                                                        | Fix Commit           | Deployed                            |
| ----------- | -------------------------------------------------------------- | -------------------- | ----------------------------------- |
| **BUG-001** | CBB moneylines missing — UTC date filter + 4+3 team code split | `4fe04f5`, `ed452b0` | Yes (visual confirm pending Feb 19) |
| **BUG-002** | Wrong game dates — downstream of BUG-001                       | Same as BUG-001      | Yes                                 |
| **BUG-003** | Start times wrong timezone                                     | `dfa2c02`            | Yes                                 |
| **BUG-004** | DateDisplay UTC shift for ISO datetimes                        | `8fa9187`            | Yes                                 |

---

## Open Bugs

None. All four bugs are code-complete, committed, and deployed to staging.

**BUG-001/002 have one remaining gate:** visual confirmation when CBB/NBA games resume on Kalshi (Feb 19). The code fixes are verified against the live API — no games exist for Feb 17 (All-Star break), which is correct behavior.

---

## Feature Status

| ID       | Description                                  | Status                                                                           |
| -------- | -------------------------------------------- | -------------------------------------------------------------------------------- |
| FEAT-001 | Sortable time-ordered odds screen            | SHIPPED (`dfa2c02`) — default chrono sort + 12h Vegas time                       |
| FEAT-002 | Book sweep — Shift+click IOC execution       | SHIPPED (`fa3ebc5`) — SweepConfirmPanel + IOC orders                             |
| FEAT-003 | Dollar amounts on order book                 | SHIPPED (`fa3ebc5`) — Cost + Depth $ columns                                     |
| FEAT-004 | Inline book panel on odds click              | REPLACED by FEAT-007 — GameDetailPanel right-side panel                          |
| FEAT-005 | Dollar risk/win on odds table cells          | SHIPPED (`53181b6`) — risk/win $ shown on moneyline cells                        |
| FEAT-006 | Odds API client with caching + team matching | SHIPPED (`319ec9d`) — client built, NOT wired to UI yet                          |
| FEAT-007 | Exchange-style order book panel              | SHIPPED — ExchangeOrderBook + GameDetailPanel (right-side, sweep depth, stacked) |
| FEAT-008 | NFL tab removal (season over)                | SHIPPED — commented out in SPORT_CONFIGS, preserved for future                   |
| FEAT-009 | Table column cleanup + venue grouping        | SHIPPED (`40491bd`) — venue grouping, vol/liq split, removed volume/RiskWin      |
| FEAT-010 | Build commit hash in status bar              | SHIPPED (`80f702d`) — git short hash bottom-right for deploy verification        |
| FEAT-011 | Dev Mode — all sports series explorer        | SHIPPED — Settings toggle + DEV tab, series list + market table + auto-refresh   |

---

## Remaining Requests

| #   | Request                                                                 | Blocked By        | Effort |
| --- | ----------------------------------------------------------------------- | ----------------- | ------ |
| R-1 | Deploy + visual verify inline panel on staging                          | Nothing           | Zero   |
| R-2 | Visual confirm BUG-001/002 when games return (Feb 19)                   | Calendar (Feb 19) | Zero   |
| R-3 | Wire Odds API into table UI (rotation numbers, sportsbook odds columns) | R-4 (API key)     | Medium |
| R-4 | Obtain + configure `VITE_ODDS_API_KEY`                                  | StreamRift action | Small  |
| R-5 | ~~Hide volume columns when inline panel is open~~                       | —                 | —      |

---

_Last updated: 2026-02-18 (session 7 — dev mode series explorer)_
