# Changelog

> All notable changes to Galactus. User-facing — feeds the in-app changelog feature.

---

## [0.5.0] — 2026-02-19 — Stabilization + Order Books

### Added

- **In-app diagnostics page** — 12 health checks across connectivity, discovery, stream, data, and date categories. Accessible via Bug icon in sidebar. Streams results live with expandable JSON details.
- **53 unit/integration tests** — critical-path coverage for date logic, ticker parsing, orderbook transforms, pricing parity, stream lifecycle, and market grouping (up from ~2% to meaningful coverage)
- **Date navigator** — date picker + prev/next/today/all buttons in Value Dashboard header
- **API status pills** — Kalshi, Feed, Poly, Odds connection indicators in top header bar
- **Rotation numbers** — Vegas rotation numbers in dev explorer + value dashboard moneyline tables
- **Exchange-style order book panel** — vertical ladder layout matching Kalshi/Polymarket UI with sweep depth, cumulative cost, hover highlighting
- **Right-side GameDetailPanel** — 380px panel with team tabs, stacked Kalshi + Polymarket order books, price summary grid, quick trade buttons
- **K Vol / P Vol columns** — contract count columns alongside dollar liquidity bars for both Kalshi and Polymarket
- **Build commit hash** — bottom-right status bar shows deployed git commit for version verification
- **Dev Mode** — Settings toggle + DEV tab in Value Dashboard to browse all Kalshi sports series with live markets, bid/ask, volume, and OI for pipeline testing during off-season
- **Click-to-trade from Dev Explorer** — click any market row in Sports Inventory to open order ticket pre-filled with ticker + price
- **Free-text market ticker in Order Ticket** — type or paste any Kalshi ticker directly, with filtered suggestion list for known markets
- `/make-it-so` slash command for Hand Kit (execute approved plans)
- Auto-seed Kalshi credentials from `.env` for faster local dev setup
- Combined `npm run dev` command (dashboard + relay via concurrently)
- Feature backlog and version planning documents
- Session debrief reports

### Fixed

- **Auto-snap race condition** — date selector no longer snaps to wrong date while games are still loading
- **Diagnostics memory leak** — generator cleanup on unmount, concurrent-run guard
- **Browser compatibility** — replaced `AbortSignal.timeout()` with manual AbortController for Safari <16.4
- **Pricing test fixtures** — removed external file dependency, inline fixtures match production logic

### Changed

- **Table columns grouped by venue** — Kalshi price + K Vol + K Liq together, then Poly price + P Vol + P Liq together across all table types (moneylines, spreads, totals)
- **Ladder rows match parent styling** — same font weight, size, and alignment as game rows (no longer faded/smaller)
- **Game click opens right-side panel** instead of inline expansion (Professor feedback)
- Single-select game expansion (clicking new game closes previous)
- Strict port binding for Vite dev servers (no silent port drift)
- Codebase audit and dead code removal
- Type consolidation (single canonical definitions for core domain types)
- Development process formalized (version planning, regression gates, commit discipline)

### Removed

- **5min / 10min / 30min volume columns** — removed from both table layouts
- **Risk/Win sub-lines** (R$0.11/W$0.89) — removed from price cells
- NFL sport tab (season over, preserved in code for future reactivation)
- InlineBookPanel component (replaced by GameDetailPanel)

---

## [0.4.0] — 2026-02-18 — streamrift-0.4

### Added

- Auto-deploy on push + stale tab version check banner
- Refresh cache button in sidebar (preserves credentials)
- Odds API client with caching, team matching, rotation numbers
- Dollar risk/win display on odds table cells
- Inline book panel in table row expansion (both dashboards)
- Order book dollar columns (Cost + Depth $)
- Book sweep (Shift+click stages sweep, IOC order execution)
- Default chronological sort + 12h Vegas time display

### Fixed

- Polymarket outcome token ordering verification
- Rotation numbers only loading first 10 (Odds API limit param)
- Value Dashboard odds click navigated away instead of inline panel
- getOpenOrders 400 spam when no orders (empty guard)
- CBB date filter UTC-to-local + 4+3 team code split
- Start times wrong timezone (Vegas time)
- DateDisplay UTC shift for ISO datetimes

---

_Last updated: 2026-02-19 (v0.5.0 release — diagnostics, tests, date fixes)_
