# Deployment Summary

Short reference for building and deploying Galactus Dashboard and Galactus Relay (e.g. to WHM/cPanel). For why the relay and workflow are set up this way (PM2, .env injection, SSH), see [devops.md](devops.md).

---

## Server prerequisites (one-time)

Before the first deploy (or when adding a new cPanel user), complete the steps below once. After that, the workflow handles directory creation, .env injection, relay deps, and PM2; no WHM terminal is needed for routine deploys.

1. **SSH key and server permissions**
   - Generate (or use) an **RSA PEM** key pair; add the **public** key to the cPanel user's `~/.ssh/authorized_keys`.
   - On the server (as root or the user), set permissions so SSH accepts key login:
     - `chmod 700` on the user's home directory and on `~/.ssh`
     - `chmod 600` on `~/.ssh/authorized_keys`
   - Without this, the workflow gets "Permission denied (publickey)."

2. **Node.js**
   - Ensure Node 20 (or the version in [.github/workflows/deploy.yml](../.github/workflows/deploy.yml)) is available for the cPanel user (e.g. installed globally or via nvm/cPanel).

3. **PM2**
   - Install PM2 globally for that user: `npm install -g pm2` (or equivalent).
   - Run `pm2 startup` and **run the command it prints** (systemd/user setup) so the relay survives reboots.
   - After the first successful deploy, run `pm2 save` as that user so the process list is persisted.

4. **nginx (or proxy)**
   - Configure the proxy so requests to the dashboard's relay paths (e.g. `/dashboard/relay/http`, `/dashboard/relay/ws`) for that domain are forwarded to `localhost:RELAY_PORT` for that user (dev 8888, prod 8787). Exact path and port must match the dashboard's `VITE_RELAY_*` and the relay's `PORT`.
   - **Example nginx config** (one per domain/user; place in `/etc/nginx/conf.d/` or include from the domain's server block). Replace `RELAY_PORT` with 8888 (dev) or 8787 (prod), and adjust `server_name` and `location` if your subpath or domain differ:

   ```nginx
   # Relay proxy: /dashboard/relay/* -> localhost:RELAY_PORT
   location /dashboard/relay/ {
       proxy_pass http://127.0.0.1:RELAY_PORT/relay/;
       proxy_http_version 1.1;
       proxy_set_header Host $host;
       proxy_set_header X-Real-IP $remote_addr;
       proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
       proxy_set_header X-Forwarded-Proto $scheme;
       # WebSocket upgrade for /relay/ws
       proxy_set_header Upgrade $http_upgrade;
       proxy_set_header Connection "upgrade";
       proxy_read_timeout 86400;
   }
   ```

   - **How-to:** Create a file (e.g. `/etc/nginx/conf.d/galactus-relay-DOMAIN.conf`) or include the `location` block inside the existing `server { ... }` for that domain. Run `nginx -t` to test, then `systemctl reload nginx` (or `nginx -s reload`) to apply. Ensure the relay is listening on `RELAY_PORT` (workflow starts it via PM2).

5. **GitHub Secrets**
   - In the repo: **Settings → Secrets and variables → Actions**, add:
     - `SSH_PRIVATE_KEY` – private half of the RSA PEM key (entire contents, including `-----BEGIN/END ...-----`).
     - `SERVER_IP` – server hostname or IP for SSH/rsync.
     - `DASHBOARD_PASSWORD_HASH` – SHA-256 hash of the dashboard gate password (baked into the frontend build).
     - `DEV_CPANEL_USER` – cPanel username for dev (e.g. dvgbuff).
     - `PROD_CPANEL_USER` – cPanel username for prod (e.g. ktgbuff).
     - `RELAY_ENV_DEV` – relay env file contents for dev (CORS_ORIGIN, etc.; newline-separated; workflow appends `PORT=8888`).
     - `RELAY_ENV_PROD` – relay env file contents for prod (workflow appends `PORT=8787`).

**After prerequisites:** Push to `dev` or `main`; the workflow builds, deploys, creates directories, injects .env, installs relay deps, starts PM2, and runs the health check. No WHM terminal needed for routine deploys.

---

## Dashboard (subpath, e.g. `/dashboard`)

1. **Configure env**
   - In `apps/dashboard/`, copy `.env.example` to `.env`.
   - Set:
     - `VITE_ROUTER_BASE` – subpath (e.g. `dashboard` or `/dashboard`). Also used by Vite for asset base URL.
     - `VITE_DASHBOARD_PASSWORD_HASH` – SHA-256 hash of the gate password.
     - `VITE_RELAY_HTTP_URL` – full path the browser will use for relay HTTP (e.g. `/dashboard/relay/http`), matching nginx/proxy.
     - `VITE_RELAY_WS_URL` – full WebSocket URL the browser will use (e.g. `wss://yourdomain.com/dashboard/relay/ws`), matching nginx/proxy.

2. **Build**
   - From repo root: `npm run dashboard:build`.

3. **Deploy**
   - Copy `apps/dashboard/dist/*` into the server’s dashboard directory (e.g. `public_html/.../dashboard/`).

4. **Recreate `.htaccess`**
   - The build does not include `.htaccess`. After every deploy, recreate it in the same directory:
     - `RewriteBase` set to your subpath (e.g. `/dashboard/`).
     - SPA fallback: serve `index.html` for non-file, non-dir requests.
     - Cache headers for HTML (no-cache) as in the WHM/cPanel footguns guide.

---

## Relay

1. **Configure env**
   - Set env via `apps/relay/.env` (copy from `.env.example`; loaded at startup) or via PM2 ecosystem file / shell exports.

2. **Build and run**
   - From repo root: `npm run relay:build`.
   - Start with the ecosystem file: from `apps/relay`, `pm2 start ecosystem.config.cjs` (required for correct cwd and .env under PM2; see [devops.md](devops.md)).
   - `pm2 save` and `pm2 startup` as needed for persistence.

3. **Proxy**
   - nginx (or Apache) must proxy the same paths as in the dashboard’s `VITE_RELAY_HTTP_URL` and `VITE_RELAY_WS_URL` to the relay (e.g. port 8787).

---

## Checklist

- [ ] Server prerequisites (above) completed once per user.
- [ ] Dashboard `.env` has `VITE_ROUTER_BASE`, `VITE_DASHBOARD_PASSWORD_HASH`, `VITE_RELAY_HTTP_URL`, `VITE_RELAY_WS_URL` set for the target subpath and domain.
- [ ] Dashboard built after any `.env` change (`npm run dashboard:build`).
- [ ] `.htaccess` recreated in the dashboard deploy directory after copying `dist/*`.
- [ ] Relay .env present in deploy dir; relay started via `pm2 start ecosystem.config.cjs`; relay running (e.g. `curl localhost:8787/health`).
- [ ] nginx/proxy paths match the dashboard’s relay URLs.

**Troubleshooting:** If the relay shows online but does not listen or log, see [devops.md](devops.md) (PM2 cwd and entry guard).
