### Kalshi ticker forms: NBA, NCAAB (CBB), NHL

This is a **best-effort general form** summary based on live samples from Kalshi.

Kalshi sports tickers come in two layers:

- **Event tickers**: identify the matchup (and date token).
- **Market tickers**: identify the specific market inside the event (team, strike, etc.).

`YYMONDD` is a Kalshi date token like `26FEB04`.  
`{AWAY}{HOME}` is the concatenation of two team codes (usually 3–5 chars each, league dependent).

---

## NBA

### Moneylines

- **Event**: `KXNBAGAME-YYMONDD{AWAY}{HOME}`
  - Example: `KXNBAGAME-26FEB04MEMSAC`
- **Market**: `KXNBAGAME-YYMONDD{AWAY}{HOME}-{TEAM}`
  - Examples:
    - `KXNBAGAME-26FEB04MEMSAC-SAC`
    - `KXNBAGAME-26FEB04MEMSAC-MEM`

### Totals

- **Event**: `KXNBATOTAL-YYMONDD{AWAY}{HOME}`
  - Example: `KXNBATOTAL-26FEB04MEMSAC`
- **Market**: `KXNBATOTAL-YYMONDD{AWAY}{HOME}-{STRIKE}`
  - Example: `KXNBATOTAL-26JAN29MILWAS-239`
- **Side mapping**:
  - `OVER` exposure = **YES**
  - `UNDER` exposure = **NO**

### Spreads

- **Event**: `KXNBASPREAD-YYMONDD{AWAY}{HOME}`
  - Example: `KXNBASPREAD-26FEB04MEMSAC`
- **Market (common)**: `KXNBASPREAD-YYMONDD{AWAY}{HOME}-{TEAM}{BUCKET}`
  - Historical example (from our parser assumptions): `KXNBASPREAD-26JAN09LACBKN-LAC6`
  - **Important**:
    - The trailing digits are typically a **bucket/index**, not a reliable float strike.
    - The most reliable strike parsing is from the **market title**: `Team wins by over X points`

---

## NCAAB (CBB)

Kalshi uses `KXNCAAMB...` series tickers for NCAAB men’s basketball.

### Moneylines

- **Event**: `KXNCAAMBGAME-YYMONDD{AWAY}{HOME}`
  - Example: `KXNCAAMBGAME-26FEB04WSUORST`
- **Market**: `KXNCAAMBGAME-YYMONDD{AWAY}{HOME}-{TEAM}`
  - Examples:
    - `KXNCAAMBGAME-26FEB04WSUORST-WSU`
    - `KXNCAAMBGAME-26FEB04WSUORST-ORST`

### Totals

- **Event**: `KXNCAAMBTOTAL-YYMONDD{AWAY}{HOME}`
  - Example: `KXNCAAMBTOTAL-26FEB04WSUORST`
- **Market**: `KXNCAAMBTOTAL-YYMONDD{AWAY}{HOME}-{STRIKE}`
  - (Strike is often available as `custom_strike` in the market payload; fallback is ticker suffix.)
- **Side mapping**:
  - `OVER` exposure = **YES**
  - `UNDER` exposure = **NO**

### Spreads

- **Event**: `KXNCAAMBSPREAD-YYMONDD{AWAY}{HOME}`
  - Example: `KXNCAAMBSPREAD-26FEB04WSUORST`
- **Market (common)**: `KXNCAAMBSPREAD-YYMONDD{AWAY}{HOME}-{TEAM}{BUCKET}`
  - Example pattern seen in related leagues: `...-WSU2`, `...-ORST2` (bucketed)
  - **Important**:
    - The most reliable strike parsing is from the **market title**: `Team wins by over X points`

---

## NHL

### Moneylines

- **Event**: `KXNHLGAME-YYMONDD{AWAY}{HOME}`
  - Example: `KXNHLGAME-26FEB04VANVGK`
- **Market**: `KXNHLGAME-YYMONDD{AWAY}{HOME}-{TEAM}`
  - Examples:
    - `KXNHLGAME-26FEB04VANVGK-VGK`
    - `KXNHLGAME-26FEB04VANVGK-VAN`

### Totals

- **Event**: `KXNHLTOTAL-YYMONDD{AWAY}{HOME}`
  - Example: `KXNHLTOTAL-26FEB04VANVGK`
- **Market**: `KXNHLTOTAL-YYMONDD{AWAY}{HOME}-{STRIKE}`
  - Examples:
    - `KXNHLTOTAL-26FEB04VANVGK-5`
    - `KXNHLTOTAL-26FEB04VANVGK-6`
    - `KXNHLTOTAL-26FEB04VANVGK-7`
- **Side mapping**:
  - `OVER` exposure = **YES**
  - `UNDER` exposure = **NO**

### Spreads

- **Event**: `KXNHLSPREAD-YYMONDD{AWAY}{HOME}`
  - Example: `KXNHLSPREAD-26FEB04VANVGK`
- **Market (common)**: `KXNHLSPREAD-YYMONDD{AWAY}{HOME}-{TEAM}{BUCKET}`
  - Examples:
    - `KXNHLSPREAD-26FEB04VANVGK-VGK1`
    - `KXNHLSPREAD-26FEB04VANVGK-VGK2`
    - `KXNHLSPREAD-26FEB04VANVGK-VAN2`
  - In NHL, the bucket often maps cleanly to half-goal lines:
    - `{BUCKET}=1` → 1.5 goals, `{BUCKET}=2` → 2.5 goals (verify via title)
  - Strike is reliably parsed from title: `Team wins by over X goals?`

---

## Tennis (ATP, WTA) - Moneylines only

Kalshi uses match-level series tickers for tennis:

- **ATP**: `KXATPMATCH`
- **WTA**: `KXWTAMATCH`

### ATP Moneylines

- **Event**: `KXATPMATCH-YYMONDD{P1}{P2}`
  - Example: `KXATPMATCH-26FEB03VAVBLA` (Vavassori vs Blanchet)
- **Market**: `KXATPMATCH-YYMONDD{P1}{P2}-{PLAYER}`
  - Examples:
    - `KXATPMATCH-26FEB03VAVBLA-VAV`
    - `KXATPMATCH-26FEB03VAVBLA-BLA`

### WTA Moneylines

- **Event**: `KXWTAMATCH-YYMONDD{P1}{P2}`
  - Example: `KXWTAMATCH-26FEB03UDVPAR` (Udvardy vs Parry)
- **Market**: `KXWTAMATCH-YYMONDD{P1}{P2}-{PLAYER}`
  - Examples:
    - `KXWTAMATCH-26FEB03UDVPAR-UDV`
    - `KXWTAMATCH-26FEB03UDVPAR-PAR`

---

## UFC - Moneylines only

Kalshi uses fight-card event tickers for UFC:

- **Series**: `KXUFCFIGHT`

### UFC Moneylines

- **Event**: `KXUFCFIGHT-YYMONDD{F1}{F2}`
  - Example: `KXUFCFIGHT-26FEB07BAUDEO` (Bautista vs de Oliveira)
- **Market**: `KXUFCFIGHT-YYMONDD{F1}{F2}-{FIGHTER}`
  - Examples:
    - `KXUFCFIGHT-26FEB07BAUDEO-BAU`
    - `KXUFCFIGHT-26FEB07BAUDEO-DEO`

---

## Series / ticker patterns to avoid (futures, props, non-game events)

Within the same sport prefixes, Kalshi can list non-game markets (futures/props/editorial).
If you only want **game-like moneylines/spreads/totals**, exclude these _series tickers_ (examples sampled from open events):

### NBA (avoid)

- `KXNBA2KCOVER-*`
  - Example: `KXNBA2KCOVER-27` — “Who will be on the cover of NBA 2K27?”
- `KXNBASEATTLE-*`
  - Example: `KXNBASEATTLE-30` — “Will a Seattle pro basketball team play a game before 2030?”
- `KXNBATEAM-*`
  - Example: `KXNBATEAM-30` — “Will the NBA add a new team before 2030?”

Notes:

- These are **not** `KXNBAGAME` / `KXNBASPREAD` / `KXNBATOTAL` and should be excluded when building a pure game-market dashboard.
- The exact “avoid list” will change over time; the robust rule is: **only allow the specific game series tickers you want**, and reject everything else under the sport prefix.

---

## Tennis (ATP, WTA) — Moneylines only

Kalshi uses match-level series tickers for tennis:

- **ATP**: `KXATPMATCH`
- **WTA**: `KXWTAMATCH`

### ATP Moneylines

- **Event**: `KXATPMATCH-YYMONDD{P1}{P2}`
  - Example: `KXATPMATCH-26FEB03VAVBLA` (Vavassori vs Blanchet)
- **Market**: `KXATPMATCH-YYMONDD{P1}{P2}-{PLAYER}`
  - Examples:
    - `KXATPMATCH-26FEB03VAVBLA-VAV`
    - `KXATPMATCH-26FEB03VAVBLA-BLA`

### WTA Moneylines

- **Event**: `KXWTAMATCH-YYMONDD{P1}{P2}`
  - Example: `KXWTAMATCH-26FEB03UDVPAR` (Udvardy vs Parry)
- **Market**: `KXWTAMATCH-YYMONDD{P1}{P2}-{PLAYER}`
  - Examples:
    - `KXWTAMATCH-26FEB03UDVPAR-UDV`
    - `KXWTAMATCH-26FEB03UDVPAR-PAR`

---

## UFC — Moneylines only

Kalshi uses fight-card event tickers for UFC:

- **Series**: `KXUFCFIGHT`

### UFC Moneylines

- **Event**: `KXUFCFIGHT-YYMONDD{F1}{F2}`
  - Example: `KXUFCFIGHT-26FEB07BAUDEO` (Bautista vs de Oliveira)
- **Market**: `KXUFCFIGHT-YYMONDD{F1}{F2}-{FIGHTER}`
  - Examples:
    - `KXUFCFIGHT-26FEB07BAUDEO-BAU`
    - `KXUFCFIGHT-26FEB07BAUDEO-DEO`
