# Merge Notes

This document describes the merge that created the galactus-one monorepo.

## Source Repositories

- **node-dash** (`apps/desk-ui`) – React + Vite frontend
- **node-relay-server** – Express + WebSocket relay server

Both were merged into this unified monorepo.

## Resulting Layout

```text
galactus-one/
├── apps/
│   ├── dashboard/    # Galactus Dashboard (from desk-ui)
│   └── relay/        # Galactus Relay
├── packages/
│   └── shared/       # @galactus/shared – merged types and utilities
├── docs/
└── package.json      # Root workspace config
```

## Naming Convention

- **Galactus Dashboard** – the frontend SPA (`apps/dashboard`, `@galactus/dashboard`)
- **Galactus Relay** – the transport layer (`apps/relay`, `@galactus/relay`)
- **@galactus/shared** – shared types and utilities consumed by both apps

Kalshi remains a domain concern (API types, authentication, endpoints) but is not part of the project identity.

## Script Convention

All scripts from the root use an app-prefixed pattern:

| Script                    | Description                                   |
| ------------------------- | --------------------------------------------- |
| `npm run dashboard:dev`   | Build shared, then start dashboard dev server |
| `npm run relay:dev`       | Build shared, then start relay dev server     |
| `npm run dashboard:build` | Build dashboard for production                |
| `npm run relay:build`     | Build relay for production                    |
| `npm run dashboard:test`  | Run dashboard tests                           |
| `npm run relay:test`      | Run relay tests                               |
| `npm run build`           | Build all workspaces                          |
| `npm run test`            | Run tests in all workspaces                   |

## Implemented: Linting, Formatting, and Pre-commit

- **ESLint:** Single root config (`eslint.config.mjs`). Root `lint` and `lint:fix` run lint in all workspaces; workspace lint scripts run ESLint from root so the same config applies.
- **Prettier:** Root `.prettierrc` and `.prettierignore`; `format` and `format:check` scripts.
- **Pre-commit hooks:** husky + lint-staged runs Prettier and ESLint on staged files before each commit.
- **Commitlint:** `@commitlint/config-conventional` with husky `commit-msg` hook enforces conventional commit messages.

See [CONTRIBUTING.md](../CONTRIBUTING.md) for details on branching strategy, linting, formatting, and commit conventions.

## Next Steps

### Deploy Actions (implemented)

- **CI/CD:** GitHub Actions on push to `dev` deploy to dv.gbuff.com (user dvgbuff, relay port 8888); push to `main` deploys to kt.gbuff.com (user ktgbuff, relay port 8787). Dashboard and relay (PM2) are built, deployed, and health-checked. Secrets and server setup are documented in [deployment.md](deployment.md) and [devops.md](devops.md).

### Redeploy saga (relay under PM2)

Redeploying the relay after the merge hit SSH auth (fixed with server permissions and RSA PEM key), then relay-under-PM2 issues: process showed "online" but did not listen or log, health check connection refused, dashboard 502. Root causes were PM2 cwd, ESM entry guard under PM2, and .env resolution. Fixes: ecosystem file with `cwd` and `DOTENV_CONFIG_PATH`, `NODE_APP_INSTANCE` in the entry guard, and workflow injecting .env from secrets. Full narrative and "do not change" notes are in [devops.md](devops.md).
