# staging deployment

Manual deploy of `dev.g1.newbx.com` for smoke testing branches before merging.

Production (`g1.newbx.com`) stays untouched. Staging gets the current branch build on the same server as a cPanel subdomain.

## prerequisites (one-time, on g1.newbx.com server)

- [x] Subdomain `dev.g1.newbx.com` created via cPanel UAPI (doc root: `~/public_html/dev.g1.newbx.com/`)
- [x] SSH key configured in `~/.ssh/config` (host: `g1.newbx.com`, user: `g1bx`)
- [x] Node.js available (v25.6.1)
- [x] PM2 installed (`~/.npm-global/bin/pm2`)
- [ ] nginx proxy for relay on port 8789 (see below)
- [ ] SSL certificate for `dev.g1.newbx.com` (AutoSSL or manual)

### nginx proxy config

Add to the server block for `dev.g1.newbx.com`:

```nginx
location /relay/ {
    proxy_pass http://127.0.0.1:8789/relay/;
    proxy_http_version 1.1;
    proxy_set_header Host $host;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    proxy_read_timeout 86400;
}
```

## setup

```bash
cp scripts/.staging-env.example scripts/.staging-env
# Edit scripts/.staging-env — fill in STAGING_DASHBOARD_PASSWORD_HASH
```

## deploy

```bash
./scripts/deploy-staging.sh
```

The script builds shared → dashboard → relay with staging env vars baked in, rsyncs to the server, installs relay deps, restarts PM2, and runs health checks.

## verification

1. `curl https://dev.g1.newbx.com/` returns 200
2. Open in browser — gate → login → markets load → place order → positions
3. Compare behavior against `g1.newbx.com` (refactor = same behavior)

## relay management

```bash
ssh g1.newbx.com
export PATH=$HOME/.npm-global/bin:$PATH
pm2 logs galactus-relay --lines 50
pm2 restart galactus-relay
pm2 delete galactus-relay
```

## notes

- Dashboard serves from subdomain root (no `/dashboard` subpath)
- Staging relay runs on port **8789** (prod: 8787, dev: 8888)
- PM2 process name is `galactus-relay` (from ecosystem.config.cjs)
- Relay dir is `~/galactus-relay-dev/` (separate from any future `~/galactus-relay/`)
- No rsync on server — deploy uses `tar | ssh tar` for transfers
- `scripts/.staging-env` is gitignored — never commit it
