/**
 * Error Types
 *
 * Standardized error types for the application.
 */
/**
 * Error codes used throughout the application.
 */
export declare enum ErrorCode {
    NETWORK_ERROR = "NETWORK_ERROR",
    TIMEOUT_ERROR = "TIMEOUT_ERROR",
    VALIDATION_ERROR = "VALIDATION_ERROR",
    AUTH_ERROR = "AUTH_ERROR",
    UPSTREAM_ERROR = "UPSTREAM_ERROR",
    CONNECTION_ERROR = "CONNECTION_ERROR",
    INVALID_OPERATION = "INVALID_OPERATION"
}
/**
 * Base error class for relay-related errors.
 */
export declare class RelayError extends Error {
    code: string;
    statusCode: number;
    requestId?: string;
    constructor(message: string, code: ErrorCode, statusCode?: number, requestId?: string);
}
/**
 * Base error class for Kalshi API-related errors.
 */
export declare class KalshiApiError extends Error {
    code: string;
    statusCode: number;
    response?: unknown;
    constructor(message: string, code: ErrorCode, statusCode: number, response?: unknown);
}
/**
 * Network connectivity error.
 */
export declare class NetworkError extends RelayError {
    constructor(message?: string, requestId?: string);
}
/**
 * Request timeout error.
 */
export declare class TimeoutError extends RelayError {
    constructor(message?: string, requestId?: string);
}
/**
 * Request validation error.
 */
export declare class ValidationError extends RelayError {
    constructor(message?: string, requestId?: string);
}
/**
 * Authentication/signing error.
 */
export declare class AuthenticationError extends KalshiApiError {
    constructor(message?: string, response?: unknown);
}
/**
 * Upstream (Kalshi API) error.
 */
export declare class UpstreamError extends RelayError {
    constructor(message: string, statusCode: number, requestId?: string);
}
/**
 * Connection error (WebSocket).
 */
export declare class ConnectionError extends RelayError {
    constructor(message?: string, streamId?: string);
}
/**
 * Invalid operation error.
 */
export declare class InvalidOperationError extends RelayError {
    constructor(message?: string, streamId?: string);
}
//# sourceMappingURL=errors.d.ts.map