/**
 * Request ID Utilities
 *
 * Utilities for generating and validating unique request IDs.
 */
/**
 * Generates a unique request ID for relay requests.
 *
 * Format: timestamp-randomstring
 * Example: "1704067200000-a1b2c3d4e"
 *
 * Uses crypto.randomBytes for better randomness than Math.random.
 *
 * @returns Unique request ID string
 */
export declare function generateRequestId(): string;
/**
 * Validates that a request ID is in the correct format.
 *
 * Format: timestamp-hyphen-randomstring
 * - Timestamp: numeric string
 * - Random string: alphanumeric, 5-10 characters
 *
 * @param id - Request ID to validate
 * @returns true if valid, false otherwise
 */
export declare function isValidRequestId(id: string): boolean;
//# sourceMappingURL=requestId.d.ts.map