/**
 * Kalshi API Types
 *
 * TypeScript interfaces for Kalshi API request/response types.
 * These types represent the structure of data exchanged with Kalshi API.
 */

/**
 * Kalshi order object.
 */
export interface KalshiOrder {
  order_id: string;
  ticker: string;
  side: 'yes' | 'no';
  action: 'buy' | 'sell';
  type: 'limit' | 'market';
  count: number;
  price?: number;
  status: string;
  created_time?: string;
  updated_time?: string;
  // Additional fields may be present
  [key: string]: unknown;
}

/**
 * Kalshi market object.
 */
export interface KalshiMarket {
  ticker: string;
  title: string;
  status: string;
  // Additional fields may be present
  [key: string]: unknown;
}

/**
 * Order placement request payload.
 */
export interface KalshiOrderRequest {
  ticker: string;
  side: 'yes' | 'no';
  action: 'buy' | 'sell';
  type: 'limit' | 'market';
  count: number;
  price?: number;
}

/**
 * Order placement response.
 */
export interface KalshiOrderResponse {
  order: KalshiOrder;
}

/**
 * Order confirmation message from Kalshi WebSocket.
 */
export interface KalshiOrderConfirmation {
  type: 'order_confirmation';
  order_id: string;
  status: string;
  ticker: string;
  side: 'yes' | 'no';
  action: 'buy' | 'sell';
  count: number;
  price?: number;
  // Additional fields may be present
  [key: string]: unknown;
}

/**
 * Order failure message from Kalshi WebSocket.
 */
export interface KalshiOrderFailure {
  type: 'order_failure';
  order_id: string;
  error: string;
  ticker: string;
  // Additional fields may be present
  [key: string]: unknown;
}

/**
 * Order fill message from Kalshi WebSocket.
 */
export interface KalshiOrderFill {
  type: 'order_fill';
  order_id: string;
  fill_id: string;
  ticker: string;
  count: number;
  price: number;
  // Additional fields may be present
  [key: string]: unknown;
}

/**
 * Union type for all Kalshi WebSocket message types.
 */
export type KalshiWebSocketMessage =
  | KalshiOrderConfirmation
  | KalshiOrderFailure
  | KalshiOrderFill
  | unknown;
