#!/usr/bin/env npx ts-node
/**
 * Galactus CLI
 *
 * Command-line interface for Kalshi API exploration and trading operations.
 *
 * Usage:
 *   pnpm cli auth login          # Store credentials
 *   pnpm cli auth status         # Check auth status
 *   pnpm cli discover sports     # List all sports series
 *   pnpm cli discover markets KXNBAGAME  # List NBA game markets
 */

import { Command } from 'commander';
import { setOutputFormat } from './lib/output';
import { authCommand } from './commands/auth';
import { discoverCommand } from './commands/discover';
import { polymarketCommand } from './commands/polymarket';

const program = new Command()
  .name('galactus')
  .description('Galactus CLI - Kalshi API explorer and trading tools')
  .version('0.1.0')
  .option('--json', 'Output as JSON (machine-readable)')
  .hook('preAction', (thisCommand) => {
    const opts = thisCommand.opts();
    if (opts.json) {
      setOutputFormat('json');
    }
  });

// Add command groups
program.addCommand(authCommand);
program.addCommand(discoverCommand);
program.addCommand(polymarketCommand);

// Parse and execute
program.parse();
